﻿using System;
using System.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class AdminEditUsersRoles : BasePage
{
    private string _currentRegistry = Helpers.GetConfigEntry("Registry");
    private USER userEntry;
    private UsersManager usersManager = new UsersManager();

    public override string MenuItemName()
    {
        return "EFR ADMIN USER ROLE";
    }
    public override string AppObjectCode()
    {
        return "EFR ADMIN USER ROLE";
    }
    public override string TopMenuName()
    {
        return "Administration";
    }

    #region protected methods

    public AdminEditUsersRoles()
    {
        //Manager Save Notification Event Handler
        usersManager.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);

    }


    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldRegistryName.Value = _currentRegistry;

        if (!IsPostBack)
        {
            HiddenFieldBreadCrumbBaseText.Value = LabelBreadCrumb.Text;
            
            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? userID = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldUserID.Value = userID.GetValueOrDefault().ToString();

            //if userID is not supplied or zero then display a list of all user roles
            if (userID == null || userID == 0)
            {
                userID = 0;

                //set page display for list of all user roles
                SetFormDisplay(false);
            }
            else
            {
                //set page to display for single user role management
                SetFormDisplay(true);
            }
        }

        if (HiddenFieldUserID.Value != "0")
        {
            //Create User Entity object and Set properties to state of form
            getEntry(Convert.ToInt32(HiddenFieldUserID.Value));
            LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Users > " + userEntry.USERNAME + " > Roles";

        }
        else
        {

            LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Role Matrix";

        }
        if (IsPostBack && userEntry != null)
        {
            LoadObjectFromControls();
        }
    }
    protected void getEntry(int id)
    {
        userEntry = usersManager.SelectByID(_currentRegistry, id);

        //initial display panels
        PanelNoAccess.Visible = false;
        PanelIdNotFound.Visible = false;
        PanelObjectContent.Visible = false;

        if (userEntry == null)
        {
            PanelObjectContent.Visible = false;

            if (usersManager.UserIDExists(id))
            {
                PanelNoAccess.Visible = true;
            }
            else
            {
                PanelIdNotFound.Visible = true;
            }
        }
        else
        {
            PanelObjectContent.Visible = true;
        }
    }
    protected void ButtonDownloadToExcel_Click(object sender, EventArgs e)
    {
        UsersManager usersManager = new UsersManager();
        int countAll = usersManager.SelectListUsersVISNsCount(HiddenFieldRegistryName.Value, "", "", 0, 0);
        GridViewUserRoles.PageSize = countAll;
        GridViewUserRoles.DataBind();
        PrepareGridViewForExport(GridViewUserRoles);
        ExportGridViewToExcel(GridViewUserRoles, "EFR User Roles.xls");
    }
    #endregion protected methods

    #region Postback Events
    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        int returnSaveValue = 0;

        returnSaveValue = usersManager.Update(userEntry);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        //Set Broken Rule Error Display
        if (userEntry.BrokenRules.Count == 0)
        {
            ErrorList1.Visible = false;
        }
        else
        {
            ErrorList1.Visible = true;
        }

        ErrorList1.BrokenRules = userEntry.BrokenRules;
        
        //Refresh entity root data
        if (returnSaveValue != 0)
        {
            getEntry(Convert.ToInt32(returnSaveValue));
        }
    }
    protected void ButtonClose_Click(object sender, EventArgs e)
    {
        Response.Redirect("AdminListUsers.aspx");
    }
    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        this.TextBoxSearchCriteria.Text = "";
        HiddenFieldClearFlag.Value = "1";

        //SetFormDisplay(true);
    }
    protected void OKButton_Click(object sender, EventArgs e)
    {
        GridViewUserRoles.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";

        //SetFormDisplay(true);
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
      
        userEntry = usersManager.SelectByUsername(TextBoxSearchCriteria.Text);

        if (userEntry != null)
        {
            GridViewUserRoles.DataSourceID = "ObjectDataSourceUsersRoles";
            GridViewUserRoles.DataBind();
        }

    }
    protected void SetFormDisplay(bool isSingleUserRoleManagement)
    {
        //LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

        if (isSingleUserRoleManagement)
        {
            //set page to display for single user role management
            PanelListUserRoles.Visible = false;
            PanelRoleInformation.Visible = true;

            //Modify breadcrumb to display editing user id
            //LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Edit Roles for User ID : " + HiddenFieldUserID.Value;
            //LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Users > " + userEntry.USERNAME + " > Roles"; 
        }
        else
        {
            //set page display for list of all user roles
            PanelListUserRoles.Visible = true;
            PanelRoleInformation.Visible = false;

            //Modify breadcrumb to display adding new
            //LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > User Roles ";
            
        }
    }
    protected void CheckBoxRoleEfrTefscAdministrator_CheckedChanged(object sender, EventArgs e)
    {
        var userRole = new USER_ROLE
                           {
                               STD_ROLE_ID = (int) RoleCode.EFR_TEFSC_ADMINISTRATOR
                           };

        if (CheckBoxRoleEfrTefscAdministrator.Checked &&
                !userEntry.USER_ROLEs.Contains(userRole))
        {
            userEntry.USER_ROLEs.Add(userRole);
        }
    }
    protected void CheckBoxRoleEfrTefscCoordinator_CheckedChanged(object sender, EventArgs e)
    {
        var userRole = new USER_ROLE
        {
            STD_ROLE_ID = (int)RoleCode.EFR_TEFSC_COORDINATOR
        };

        if (CheckBoxRoleEfrTefscCoordinator.Checked &&
                !userEntry.USER_ROLEs.Contains(userRole))
        {
            userEntry.USER_ROLEs.Add(userRole);
        }
    }
    protected void CheckBoxRoleEfrTefscProvider_CheckedChanged(object sender, EventArgs e)
    {
        var userRole = new USER_ROLE
                            {
                                STD_ROLE_ID = (int)RoleCode.EFR_TEFSC_PROVIDER
                            };

        if (CheckBoxRoleEfrTefscProvider.Checked &&
                !userEntry.USER_ROLEs.Contains(userRole))
        {
            userEntry.USER_ROLEs.Add(userRole);
        }
    }
    protected void CheckBoxRoleEfrTefscNurse_CheckedChanged(object sender, EventArgs e)
    {
        var userRole = new USER_ROLE
        {
            STD_ROLE_ID = (int)RoleCode.EFR_TEFSC_NURSE
        };

        if (CheckBoxRoleEfrTefscNurse.Checked &&
                !userEntry.USER_ROLEs.Contains(userRole))
        {
            userEntry.USER_ROLEs.Add(userRole);
        }
    }
    #endregion

    #region Object/Form Mapping
    private void LoadControlsFromObject()
    {
        //Registry
        HiddenFieldRegistryName.Value = _currentRegistry;

        //Username:
        LabelUsername.Text = userEntry.USERNAME;

        //Full Name:
        LabelFullName.Text = userEntry.FULL_NAME;
        
        //Employee Number:
        LabelEmployeeNumber.Text = userEntry.EMPLOYEE_NUMBER;

        //Job Title:
        LabelJobTitle.Text = userEntry.JOB_TITLE;

        //userid 
        HiddenFieldUserID.Value = userEntry.USER_ID.ToString();

        //User Roles
        foreach (USER_ROLE userRole in userEntry.USER_ROLEs)
        {
            //EFR_TEFSC_COORDINATOR = 4
            //EFR_TEFSC_ADMINISTRATOR	= 5
            //EFR_TEFSC_PROVIDERS	= 6
            //EFR_TEFSC_NURSES = 7

            switch (userRole.STD_ROLE_ID)
            {
                case (int)RoleCode.EFR_TEFSC_ADMINISTRATOR: //5
                    CheckBoxRoleEfrTefscAdministrator.Checked = true;
                    break;
                case (int)RoleCode.EFR_TEFSC_COORDINATOR: //4
                    CheckBoxRoleEfrTefscCoordinator.Checked = true;
                    break;
                case (int)RoleCode.EFR_TEFSC_PROVIDER: //6
                    CheckBoxRoleEfrTefscProvider.Checked = true;
                    break;
                case (int)RoleCode.EFR_TEFSC_NURSE: //7
                    CheckBoxRoleEfrTefscNurse.Checked = true;
                    break;
                case (int)RoleCode.EFR_DATA_ENTRY_PERSONNEL: //20
                    CheckBoxRoleEfrTefscDataEntryPersonnel.Checked = true;
                    break;
            }
        }
    }
    private void LoadObjectFromControls()
    {
        //Remove USER Role Entries as needed  
        if (CheckBoxRoleEfrTefscAdministrator.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.EFR_TEFSC_ADMINISTRATOR);
        }
        if (CheckBoxRoleEfrTefscCoordinator.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.EFR_TEFSC_COORDINATOR);
        }
        if (CheckBoxRoleEfrTefscNurse.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.EFR_TEFSC_NURSE);
        }
        if (CheckBoxRoleEfrTefscProvider.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.EFR_TEFSC_PROVIDER);
        }
        if (CheckBoxRoleEfrTefscDataEntryPersonnel.Checked == false)
        {
            userEntry.RemoveRoleFromUser(userEntry, (int)RoleCode.EFR_DATA_ENTRY_PERSONNEL);
        }

        //Add User Roles as needed
        //EFR_TEFSC_COORDINATOR = 4
        //EFR_TEFSC_ADMINISTRATOR	= 5
        //EFR_TEFSC_PROVIDER	= 6
        //EFR_TEFSC_NURSE = 7

        //EFR_TEFSC_ADMINISTRATOR	= 5
        if (CheckBoxRoleEfrTefscAdministrator.Checked == true)
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.EFR_TEFSC_ADMINISTRATOR);
        }
        //EFR_TEFSC_COORDINATOR = 4
        //if (CheckBoxRoleEfrTefscAdministrator.Checked == true)
        if ( CheckBoxRoleEfrTefscCoordinator.Checked ) 
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.EFR_TEFSC_COORDINATOR);
        }
        //EFR_TEFSC_PROVIDER	= 6
        if (CheckBoxRoleEfrTefscProvider.Checked == true)
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.EFR_TEFSC_PROVIDER);
        }
        //EFR_TEFSC_NURSE = 7
        if (CheckBoxRoleEfrTefscNurse.Checked == true)
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.EFR_TEFSC_NURSE);
        }
        //EFR_DATA_ENTRY_PERSONNEL = 20
        if (CheckBoxRoleEfrTefscDataEntryPersonnel.Checked == true)
        {
            UpdateUserRoleNotVisnBased(userEntry, (int)RoleCode.EFR_DATA_ENTRY_PERSONNEL);
        }
    }
    #endregion

    #region private methods
    private void Page_PreRender(object sender, EventArgs e)
    {
        if (userEntry != null)
        {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack)
            {
                int ret;
                ret = usersManager.EnforceBusinessRules(ref userEntry);
            }

            if (!IsPostBack)
            {
                //Load Controls from the Object
                LoadControlsFromObject();
            }
        }
    }
    private void UpdateUserRoleNotVisnBased(USER userEntity, int roleID)
    {
        if (!userEntity.USER_ROLEs.Any(e => e.STD_ROLE_ID == roleID && e.INACTIVE_FLAG == false))
        {
            USER_ROLE role = new USER_ROLE();
            role.STD_ROLE_ID = roleID;
            role.STD_INSTITUTION_ID = STD_INSTITUTION.TopInstitutionId;
            userEntry.USER_ROLEs.Add(role);
        }
    }
    #endregion private methods
}

